---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-Test Results Storage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **目標読み込み/保存時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - RETAIN_MAX_RESULTS (行21)
- E-02: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - RETAIN_MIN_RESULTS (行22)
- E-03: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - RETAIN_MAX_BYTES (行23)
- E-04: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - CLEANUP_PROBABILITY (行24)
- E-05: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - currentRevision (行47)
- E-06: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - ITestResultStorage interface (行26-38)
- E-07: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - BaseTestResultStorage.read() (行70-95)
- E-08: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - BaseTestResultStorage.persist() (行109-150)
- E-09: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - TestResultStorage (行213-300)
- E-10: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - cleanupDereferenced() (行278-291)
- E-11: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - stored StoredValue (行52-64)
- E-12: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - getResultJsonPath() (行293-295)
- E-13: `src/vs/workbench/contrib/testing/common/testResultStorage.ts` - getResultOutputPath() (行297-299)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最大保持件数は128件 | E-01 (RETAIN_MAX_RESULTS = 128) | ○ |
| C-02 | 最小保持件数は16件 | E-02 (RETAIN_MIN_RESULTS = 16) | ○ |
| C-03 | 最大保持バイト数は128KB | E-03 (RETAIN_MAX_BYTES = 1024 * 128) | ○ |
| C-04 | クリーンアップ確率は20% | E-04 (CLEANUP_PROBABILITY = 0.2) | ○ |
| C-05 | データリビジョンは1 | E-05 (currentRevision = 1) | ○ |
| C-06 | read()でHydratedTestResult[]を返す | E-06, E-07 | ○ |
| C-07 | persist()でITestResult[]を保存 | E-06, E-08 | ○ |
| C-08 | リビジョン不一致でスキップ | E-07 (行72-74) | ○ |
| C-09 | 読み込みエラーでwarnログ | E-07 (行84) | ○ |
| C-10 | 有効結果のみstored更新 | E-07 (行90-92) | ○ |
| C-11 | バジェット計算でループ制御 | E-08 (行119-122) | ○ |
| C-12 | 既存結果はバイト数引き継ぎ | E-08 (行125-130) | ○ |
| C-13 | 新規結果はJSON.stringifyでバイト計算 | E-08 (行138) | ○ |
| C-14 | 削除対象をdeleteForResultId | E-08 (行144-146) | ○ |
| C-15 | stored.storeでメタデータ保存 | E-08 (行148) | ○ |
| C-16 | ディレクトリはworkspaceStorageHome/workspaceId/testResults | E-09 (行225) | ○ |
| C-17 | 結果ファイルは{id}.json | E-12 | ○ |
| C-18 | 出力ファイルは{id}.output | E-13 | ○ |
| C-19 | readForResultIdでJSONパース | E-09 (行228-230) | ○ |
| C-20 | storeForResultIdでJSON書き込み | E-09 (行233-234) | ○ |
| C-21 | persist()で20%確率でクリーンアップ | E-09 (行269-271) | ○ |
| C-22 | クリーンアップで孤児ファイル削除 | E-10 (行286-289) | ○ |
| C-23 | StorageScope.WORKSPACEで保存 | E-11 (行62) | ○ |
| C-24 | StorageTarget.MACHINEで保存 | E-11 (行63) | ○ |
| C-25 | storedTestResultsキーで管理 | E-11 (行61) | ○ |
| C-26 | 目標保存/読み込み時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標保存/読み込み時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 保持制限の定数値（E-01〜E-04に基づく）
- 0: 低リスク - ストレージパス構造（E-09, E-12, E-13に基づく）
- 0: 低リスク - バジェット計算ロジック（E-08に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] 保持制限値（128件、16件、128KB、20%）が最新実装と一致しているか
- [ ] ストレージパス構造が実装と一致しているか
- [ ] read()/persist()の処理フローが実装と一致しているか
- [ ] リビジョン管理の仕組みが正しく記載されているか
